/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf.javascript;

import com.qoppa.pdf.b.eb;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeObject;

public class QJSUtil {
    public static Object parse(String string) {
        if (string == null) {
            return "";
        }
        try {
            Double d2 = Double.valueOf(string);
            Double d3 = d2.intValue();
            if (d2.equals(d3)) {
                return d2.intValue();
            }
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public static String toString(Object object) {
        if (object instanceof Double) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
            numberFormat.setGroupingUsed(false);
            return numberFormat.format(object);
        }
        return object.toString();
    }

    public static String arrayToString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(objectArray[0].toString());
        int n2 = 1;
        while (n2 < objectArray.length) {
            stringBuffer.append(", " + objectArray[n2].toString());
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static Vector<String> getVector(Object object) {
        Vector<String> vector = new Vector<String>();
        if (object instanceof Object[]) {
            vector.addAll(Arrays.asList((String[])object));
        } else if (object instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)object;
            int n2 = 0;
            while (n2 < nativeArray.size()) {
                vector.add((String)nativeArray.get(n2));
                ++n2;
            }
        } else {
            vector.add(eb.b(object));
        }
        return vector;
    }

    public static Object[] getArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object instanceof NativeArray) {
            return ((NativeArray)object).toArray();
        }
        if (object instanceof NativeJavaArray) {
            return (Object[])((NativeJavaArray)object).unwrap();
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public static Hashtable<Object, Object> getArgumentsMap(Object[] objectArray, String[] stringArray) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (objectArray.length > 0 && objectArray[0] instanceof NativeObject) {
            NativeObject nativeObject = (NativeObject)objectArray[0];
            for (Object e2 : nativeObject.keySet()) {
                hashtable.put(e2, nativeObject.get(e2));
            }
        } else {
            int n2 = 0;
            while (n2 < objectArray.length) {
                hashtable.put(stringArray[n2], objectArray[n2]);
                ++n2;
            }
        }
        return hashtable;
    }

    public static class JSUnsupportedException
    extends Exception {
        public JSUnsupportedException(String string) {
            super(string);
        }
    }
}

