/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf;

import com.qoppa.pdf.PDFException;
import com.qoppa.pdf.SignatureAppearance;
import com.qoppa.pdf.TimestampServer;
import com.qoppa.pdf.b.fb;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SigningInformation {
    @Deprecated
    private static String[] h = new String[]{"SHA1", "SHA256", "SHA384", "SHA512", "RIPEMD160"};
    private static String[] n = new String[]{"SHA512", "SHA384", "RIPEMD160", "SHA256", "SHA1"};
    private static String[] o = new String[]{"SHA256", "SHA1"};
    private static String[] p = new String[]{"SHA1", "SHA256"};
    public static int PERM_NOCHANGES = 1;
    public static int PERM_FORMFILL_SIGNATURE = 2;
    public static int PERM_FORMFILL_SIGNATURE_COMMENTS = 3;
    public static int FORMAT_PKCS7 = 0;
    public static int FORMAT_PADES = 1;
    public static int FORMAT_DOCUMENT_TIMESTAMP = 2;
    private PrivateKey i;
    protected Certificate l;
    protected Certificate[] g;
    private String r;
    private String d;
    private String s;
    private String k;
    private boolean e;
    private SignatureAppearance t = new SignatureAppearance();
    private TimestampServer m;
    private Hashtable<String, String> c;
    private boolean f;
    private int q = PERM_FORMFILL_SIGNATURE;
    private int b = FORMAT_PKCS7;
    private ContentSigner j;

    protected SigningInformation() {
    }

    public SigningInformation(String string, String string2, String string3, String string4) throws GeneralSecurityException, IOException, PDFException {
        FileInputStream fileInputStream = new FileInputStream(string);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(fileInputStream, string2.toCharArray());
        fileInputStream.close();
        if (string3 == null) {
            string3 = this.b(keyStore);
        }
        if (!keyStore.containsAlias(string3)) {
            throw new PDFException("Invalid signature alias.");
        }
        if (!keyStore.isKeyEntry(string3)) {
            throw new PDFException("Signature alias is not a key entry.");
        }
        this.i = (PrivateKey)keyStore.getKey(string3, string4.toCharArray());
        this.l = keyStore.getCertificate(string3);
        this.g = keyStore.getCertificateChain(string3);
        if (!this.b()) {
            throw new PDFException("Certificate contains Invalid Key Usage.");
        }
    }

    private String b(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        if (enumeration.hasMoreElements()) {
            return enumeration.nextElement();
        }
        return null;
    }

    public SigningInformation(KeyStore keyStore, String string, String string2) throws GeneralSecurityException, PDFException {
        if (string == null) {
            string = this.b(keyStore);
        }
        if (!keyStore.containsAlias(string)) {
            throw new PDFException("Invalid signature alias.");
        }
        if (!keyStore.isKeyEntry(string)) {
            throw new PDFException("Signature alias is not a key entry.");
        }
        this.i = (PrivateKey)keyStore.getKey(string, string2.toCharArray());
        this.l = keyStore.getCertificate(string);
        this.g = keyStore.getCertificateChain(string);
        if (!this.b()) {
            throw new PDFException("Certificate contains Invalid Key Usage.");
        }
    }

    public SigningInformation(PrivateKey privateKey, Certificate certificate, Certificate[] certificateArray, String string) throws PDFException {
        this.i = privateKey;
        this.l = certificate;
        this.g = certificateArray;
        this.r = string;
        if (!this.b()) {
            throw new PDFException("Certificate contains Invalid Key Usage.");
        }
    }

    public SigningInformation(ContentSigner contentSigner, Certificate certificate, Certificate[] certificateArray) {
        this.j = contentSigner;
        this.l = certificate;
        this.g = certificateArray;
    }

    public SigningInformation(TimestampServer timestampServer) {
        this.m = timestampServer;
        this.b = FORMAT_DOCUMENT_TIMESTAMP;
    }

    public ContentSigner getContentSigner() {
        if (this.j != null) {
            return this.j;
        }
        try {
            return this.b(this.i, this.r, h);
        }
        catch (PDFException pDFException) {
            pDFException.printStackTrace();
            return null;
        }
    }

    public ContentSigner getContentSigner(String string) throws PDFException {
        if (this.j != null) {
            return this.j;
        }
        return this.b(this.i, this.r, this.b(string));
    }

    private String[] b(String string) {
        double d2 = Double.parseDouble(string);
        if (d2 >= 1.7) {
            return n;
        }
        if (d2 >= 1.6) {
            return o;
        }
        return p;
    }

    public String getContactInformation() {
        return this.k;
    }

    public void setContactInformation(String string) {
        this.k = string;
    }

    public String getLocation() {
        return this.s;
    }

    public void setLocation(String string) {
        this.s = string;
    }

    public String getReason() {
        return this.d;
    }

    public void setReason(String string) {
        this.d = string;
    }

    public PrivateKey getPrivateKey() {
        return this.i;
    }

    public String getJCEProvider() {
        return this.r;
    }

    public Certificate getSignerCertificate() {
        return this.l;
    }

    public Certificate[] getCertificateChain() {
        return this.g;
    }

    public void setSignatureAppearance(SignatureAppearance signatureAppearance) {
        this.t = signatureAppearance;
    }

    public SignatureAppearance getSignatureAppearance() {
        return this.t;
    }

    public String getCustomProperty(String string) {
        if (this.c != null) {
            return this.c.get(string);
        }
        return null;
    }

    public void setCustomProperty(String string, String string2) throws PDFException {
        if (this.c == null) {
            this.c = new Hashtable();
        }
        this.c.put(string, string2);
    }

    public Map<String, String> getCustomProperties() {
        return this.c;
    }

    public TimestampServer getTimestampServer() {
        return this.m;
    }

    public void setTimestampServer(TimestampServer timestampServer) {
        this.m = timestampServer;
    }

    private boolean b() {
        boolean[] blArray;
        return !(this.l instanceof X509Certificate) || (blArray = ((X509Certificate)this.l).getKeyUsage()) == null || blArray[0] || blArray[1];
    }

    public void setCertifyingSignature(boolean bl) {
        this.f = bl;
    }

    public boolean isCertifyingSignature() {
        return this.f;
    }

    public void setPermissions(int n2) throws PDFException {
        if (n2 < 1 || n2 > 3) {
            throw new PDFException(fb.b.b("InvalidPermissions"));
        }
        this.q = n2;
    }

    public int getPermissions() {
        return this.q;
    }

    public void setSignatureFormat(int n2) {
        this.b = n2;
    }

    public int getSignatureFormat() {
        return this.b;
    }

    public boolean isLock() {
        return this.e;
    }

    public void setLock(boolean bl) {
        this.e = bl;
    }

    private ContentSigner b(PrivateKey privateKey, String string, String[] stringArray) throws PDFException {
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder(String.valueOf(stringArray[n2]) + "with" + privateKey.getAlgorithm());
                if (string != null) {
                    jcaContentSignerBuilder.setProvider(string);
                }
                return jcaContentSignerBuilder.build(privateKey);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                ++n2;
            }
        }
        throw new PDFException("JCE Provider does not support SHA hash algorithm.  Private Key Algorithm: " + privateKey.getAlgorithm());
    }
}

