/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf.source;

import com.qoppa.pdf.PDFException;
import com.qoppa.pdf.b.i;
import com.qoppa.pdf.d.c;
import com.qoppa.pdf.source.PDFContent;
import com.qoppa.pdf.source.PDFSource;
import java.io.File;
import java.io.IOException;

public class FilePDFSource
implements PDFSource {
    private File r;
    private PDFContent s;

    public FilePDFSource(File file) throws PDFException {
        if (file == null) {
            throw new PDFException("File is null.");
        }
        this.r = file;
        if (!this.r.exists()) {
            throw new PDFException("File does not exist: " + file.getName());
        }
    }

    public FilePDFSource(String string) throws PDFException {
        if (string == null) {
            throw new PDFException("File name is null.");
        }
        this.r = new File(string);
        if (!this.r.exists()) {
            throw new PDFException("File does not exist: " + string);
        }
    }

    @Override
    public String getName() {
        return this.r.getName();
    }

    @Override
    public String getPath() {
        try {
            return this.r.getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.r.getAbsolutePath();
        }
    }

    @Override
    public boolean equals(PDFSource pDFSource) {
        if (pDFSource instanceof FilePDFSource) {
            return ((FilePDFSource)pDFSource).r.equals(this.r);
        }
        return false;
    }

    public File getFile() {
        return this.r;
    }

    @Override
    public PDFContent getContent() throws IOException {
        if (this.s == null) {
            this.s = new c(i.b(this.r));
        }
        return this.s;
    }
}

