/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthorityType;
import com.microsoft.aad.adal4j.HttpHelper;
import com.microsoft.aad.adal4j.InstanceDiscoveryResponse;
import com.microsoft.aad.adal4j.JsonHelper;
import com.microsoft.aad.adal4j.LogHelper;
import com.microsoft.aad.adal4j.StringHelper;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthenticationAuthority {
    private final Logger log = LoggerFactory.getLogger(AuthenticationAuthority.class);
    private static final String[] TRUSTED_HOST_LIST = new String[]{"login.windows.net", "login.chinacloudapi.cn", "login-us.microsoftonline.com", "login.microsoftonline.de", "login.microsoftonline.com"};
    private static final String TENANTLESS_TENANT_NAME = "common";
    private static final String AUTHORIZE_ENDPOINT_TEMPLATE = "https://{host}/{tenant}/oauth2/authorize";
    private static final String DISCOVERY_ENDPOINT = "common/discovery/instance";
    private static final String TOKEN_ENDPOINT = "/oauth2/token";
    private static final String USER_REALM_ENDPOINT = "common/userrealm";
    private String host;
    private String issuer;
    private final String instanceDiscoveryEndpointFormat = "https://%s/common/discovery/instance";
    private final String userRealmEndpointFormat = "https://%s/common/userrealm/%s?api-version=1.0";
    private final String tokenEndpointFormat = "https://%s/{tenant}/oauth2/token";
    private String authority = "https://%s/%s/";
    private String instanceDiscoveryEndpoint;
    private String tokenEndpoint;
    private final AuthorityType authorityType;
    private boolean isTenantless;
    private String tokenUri;
    private String selfSignedJwtAudience;
    private boolean instanceDiscoveryCompleted;
    private final URL authorityUrl;
    private final boolean validateAuthority;

    AuthenticationAuthority(URL authorityUrl, boolean validateAuthority) {
        this.authorityUrl = authorityUrl;
        this.authorityType = this.detectAuthorityType();
        this.validateAuthority = validateAuthority;
        this.validateAuthorityUrl();
        this.setupAuthorityProperties();
    }

    String getHost() {
        return this.host;
    }

    String getIssuer() {
        return this.issuer;
    }

    String getAuthority() {
        return this.authority;
    }

    String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    String getUserRealmEndpoint(String username) {
        return String.format("https://%s/common/userrealm/%s?api-version=1.0", this.host, username);
    }

    AuthorityType getAuthorityType() {
        return this.authorityType;
    }

    boolean isTenantless() {
        return this.isTenantless;
    }

    String getTokenUri() {
        return this.tokenUri;
    }

    String getSelfSignedJwtAudience() {
        return this.selfSignedJwtAudience;
    }

    void setSelfSignedJwtAudience(String selfSignedJwtAudience) {
        this.selfSignedJwtAudience = selfSignedJwtAudience;
    }

    void doInstanceDiscovery(Map<String, String> headers, Proxy proxy, SSLSocketFactory sslSocketFactory) throws Exception {
        if (!this.instanceDiscoveryCompleted) {
            if (!this.doStaticInstanceDiscovery() && this.validateAuthority && !this.doDynamicInstanceDiscovery(headers, proxy, sslSocketFactory)) {
                throw new AuthenticationException("'authority' is not in the list of valid addresses");
            }
            this.log.info(LogHelper.createMessage("Instance discovery was successful", headers.get("client-request-id")));
            this.instanceDiscoveryCompleted = true;
        }
    }

    boolean doDynamicInstanceDiscovery(Map<String, String> headers, Proxy proxy, SSLSocketFactory sslSocketFactory) throws Exception {
        String json = HttpHelper.executeHttpGet(this.log, this.instanceDiscoveryEndpoint, headers, proxy, sslSocketFactory);
        InstanceDiscoveryResponse discoveryResponse = JsonHelper.convertJsonToObject(json, InstanceDiscoveryResponse.class);
        return !StringHelper.isBlank(discoveryResponse.getTenantDiscoveryEndpoint());
    }

    boolean doStaticInstanceDiscovery() {
        if (this.validateAuthority) {
            return Arrays.asList(TRUSTED_HOST_LIST).contains(this.host);
        }
        return true;
    }

    void setupAuthorityProperties() {
        String host = this.authorityUrl.getAuthority().toLowerCase();
        String path = this.authorityUrl.getPath().substring(1).toLowerCase();
        String tenant = path.substring(0, path.indexOf("/")).toLowerCase();
        this.host = host;
        this.authority = String.format(this.authority, host, tenant);
        this.instanceDiscoveryEndpoint = String.format(this.instanceDiscoveryEndpointFormat, host);
        this.tokenEndpoint = String.format(this.tokenEndpointFormat, host);
        this.issuer = this.tokenUri = (this.tokenEndpoint = this.tokenEndpoint.replace("{tenant}", tenant));
        this.isTenantless = TENANTLESS_TENANT_NAME.equalsIgnoreCase(tenant);
        this.setSelfSignedJwtAudience(this.getIssuer());
        this.createInstanceDiscoveryEndpoint(tenant);
    }

    AuthorityType detectAuthorityType() {
        if (this.authorityUrl == null) {
            throw new NullPointerException("authority");
        }
        String path = this.authorityUrl.getPath().substring(1);
        if (StringHelper.isBlank(path)) {
            throw new IllegalArgumentException("'authority' Uri should have at least one segment in the path (i.e. https://<host>/<path>/...)");
        }
        String firstPath = path.substring(0, path.indexOf("/"));
        AuthorityType authorityType = AuthenticationAuthority.IsAdfsAuthority(firstPath) ? AuthorityType.ADFS : AuthorityType.AAD;
        return authorityType;
    }

    void validateAuthorityUrl() {
        if (this.authorityType != AuthorityType.AAD && this.validateAuthority) {
            throw new IllegalArgumentException("Authority validation is not supported for this type of authority");
        }
        if (!this.authorityUrl.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("'authority' should use the 'https' scheme");
        }
        if (this.authorityUrl.toString().contains("#")) {
            throw new IllegalArgumentException("authority is invalid format (contains fragment)");
        }
        if (!StringHelper.isBlank(this.authorityUrl.getQuery())) {
            throw new IllegalArgumentException("authority cannot contain query parameters");
        }
    }

    void createInstanceDiscoveryEndpoint(String tenant) {
        this.instanceDiscoveryEndpoint = this.instanceDiscoveryEndpoint + "?api-version=1.0&authorization_endpoint=https://{host}/{tenant}/oauth2/authorize";
        this.instanceDiscoveryEndpoint = this.instanceDiscoveryEndpoint.replace("{host}", this.host);
        this.instanceDiscoveryEndpoint = this.instanceDiscoveryEndpoint.replace("{tenant}", tenant);
    }

    static boolean IsAdfsAuthority(String firstPath) {
        return firstPath.compareToIgnoreCase("adfs") == 0;
    }
}

