/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.requests;

import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CreateKeyRequest {
    private final String vaultBaseUrl;
    private final String keyName;
    private final JsonWebKeyType keyType;
    private final Integer keySize;
    private final List<JsonWebKeyOperation> keyOperations;
    private final KeyAttributes keyAttributes;
    private final Map<String, String> tags;

    private CreateKeyRequest(Builder builder) {
        this.vaultBaseUrl = builder.vaultBaseUrl;
        this.keyName = builder.keyName;
        this.keyType = builder.keyType;
        this.keySize = builder.keySize;
        this.keyOperations = builder.keyOperations != null ? new ArrayList<JsonWebKeyOperation>(builder.keyOperations) : null;
        this.keyAttributes = builder.attributes != null ? (KeyAttributes)new KeyAttributes().withNotBefore(builder.attributes.notBefore()).withEnabled(builder.attributes.enabled()).withExpires(builder.attributes.expires()) : null;
        this.tags = builder.tags != null ? Collections.unmodifiableMap(builder.tags) : null;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String keyName() {
        return this.keyName;
    }

    public JsonWebKeyType keyType() {
        return this.keyType;
    }

    public Integer keySize() {
        return this.keySize;
    }

    public List<JsonWebKeyOperation> keyOperations() {
        return this.keyOperations;
    }

    public KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public static class Builder {
        private final String vaultBaseUrl;
        private final String keyName;
        private final JsonWebKeyType keyType;
        private Integer keySize;
        private List<JsonWebKeyOperation> keyOperations;
        private KeyAttributes attributes;
        private Map<String, String> tags;

        public Builder(String vaultBaseUrl, String keyName, JsonWebKeyType keyType) {
            this.vaultBaseUrl = vaultBaseUrl;
            this.keyName = keyName;
            this.keyType = keyType;
        }

        public Builder withKeySize(Integer size) {
            this.keySize = size;
            return this;
        }

        public Builder withKeyOperations(List<JsonWebKeyOperation> keyOperations) {
            this.keyOperations = keyOperations;
            return this;
        }

        public Builder withAttributes(Attributes attributes) {
            this.attributes = (KeyAttributes)attributes;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public CreateKeyRequest build() {
            return new CreateKeyRequest(this);
        }
    }
}

