package jPDFPreflightSamples;

import java.io.IOException;

import com.qoppa.pdf.PDFException;
import com.qoppa.pdfPreflight.PDFPreflight;
import com.qoppa.pdfPreflight.profiles.PDF_UA_Verification;
import com.qoppa.pdfPreflight.results.PreflightResults;

/**
 * 
 * This is a Java sample program using Qoppa's library jPDFPreflight. 
 * It opens PDF, validates against the PDF/UA sub-format (ISO 14289), 
 * then adds annotations on the PDF where errors are found and
 * attaches a Preflight validation report at the end of the PDF.
 */
public class ValidatePDFUA {

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		try
		{
			System.out.println("Starting");
			PDFPreflight pdfPreflight = new PDFPreflight("C:\\tmp\\input.pdf", null);
			
			// Validate the document
			PreflightResults results = pdfPreflight.verifyDocument(new PDF_UA_Verification(), null);
			if (results.isSuccessful())
			{
				System.out.println("PDF is PDF/UA compliant");
			}
			else
			{
				System.out.println("PDF is not PDF/UA compliant");
				// Add annotations to the document
				pdfPreflight.addResultAnnotations(results);
				// Append report to the document
				pdfPreflight.appendPreflightReport(results, 612, 792); 
				// Save the PDF document with annotations and report
				pdfPreflight.saveDocument("C:\\tmp\\validationreport.pdf"); 
			}
		}
		catch(PDFException pdfe)
		{
			System.out.println(pdfe);
		}
		catch(IOException ioe)
		{
			System.out.println(ioe);
		}
		catch(Throwable t)
		{
			System.out.println(t);
		}

	}

}
