package jPDFPreflightSamples;

import java.io.IOException;

import com.qoppa.pdf.PDFException;
import com.qoppa.pdfPreflight.PDFPreflight;
import com.qoppa.pdfPreflight.ProgressListener;
import com.qoppa.pdfPreflight.profiles.PDFA_1_B_Verification;
import com.qoppa.pdfPreflight.results.PreflightResults;
import com.qoppa.pdfPreflight.results.ResultRecord;

public class ValidatePDFA_FailFast
{
	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		try
		{
			System.out.println("Starting");
			PDFPreflight pdfPreflight = new PDFPreflight("C:\\input.pdf", null);
			
			/*
			 * create a new ProgressListener instance that will tell the preflight operation
			 * to cancel running once the first ResultRecord is generated 
			 * In general a ResultRecord indicates failure of verification. A user
			 * may or may not be interested in generating the full list of Result Records.
			 * This mechanism allows for quick termination of the application when all the
			 * reasons for verification failure are not desired.
			 */
			ProgressListener listener = new ProgressListener(){
				
				private boolean shouldCancel = false; 

				@Override
				public void progress(int pageNumber, int percent, String message)
				{
					//ignore
				}

				@Override
				public boolean shouldCancel()
				{
					return shouldCancel;
				}

				@Override
				public void resultAdded(ResultRecord result)
				{
					shouldCancel = true;
				}
				
			};
			
			// Validate the document
			PreflightResults results = pdfPreflight.verifyDocument(new PDFA_1_B_Verification(), listener);
			if (results.isSuccessful())
			{
				System.out.println("PDF is compliant");
			}
			else
			{
				System.out.println("PDF is not compliant");
				// Add annotations to the document
				pdfPreflight.addResultAnnotations(results);
				// Append report to the document
				pdfPreflight.appendPreflightReport(results, 612, 792); 
				// Save the PDF document with annotations and report
				pdfPreflight.saveDocument("C:\\validationreport.pdf"); 
			}
		}
		catch(PDFException pdfe)
		{
			System.out.println(pdfe);
		}
		catch(IOException ioe)
		{
			System.out.println(ioe);
		}
		catch(Throwable t)
		{
			System.out.println(t);
		}

	}

}
