package jPDFPreflightSamples;

import java.io.IOException;

import com.qoppa.pdf.PDFException;
import com.qoppa.pdfPreflight.PDFPreflight;
import com.qoppa.pdfPreflight.profiles.PDFA_1_B_Verification;
import com.qoppa.pdfPreflight.results.PreflightResults;

public class ValidatePDFA {

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		try
		{
			System.out.println("Starting");
			PDFPreflight pdfPreflight = new PDFPreflight("C:\\input.pdf", null);
			
			// Validate the document
			PreflightResults results = pdfPreflight.verifyDocument(new PDFA_1_B_Verification(), null);
			if (results.isSuccessful())
			{
				System.out.println("PDF is compliant");
			}
			else
			{
				System.out.println("PDF is not compliant");
				// Add annotations to the document
				pdfPreflight.addResultAnnotations(results);
				// Append report to the document
				pdfPreflight.appendPreflightReport(results, 612, 792); 
				// Save the PDF document with annotations and report
				pdfPreflight.saveDocument("C:\\validationreport.pdf"); 
			}
		}
		catch(PDFException pdfe)
		{
			System.out.println(pdfe);
		}
		catch(IOException ioe)
		{
			System.out.println(ioe);
		}
		catch(Throwable t)
		{
			System.out.println(t);
		}

	}

}
