package jPDFPreflightSamples;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;

import com.qoppa.pdfPreflight.ProgressListener;
import com.qoppa.pdfPreflight.results.ResultRecord;

public class ProgressDialog extends JDialog implements ProgressListener
{
	private JPanel jPanel;
	private JLabel jlDocument;
	private JLabel jlMessage;
	private JProgressBar jProgressBar;
	private JButton jbCancel;
	
	private boolean isCanceled = false;

	public ProgressDialog(Frame frame)
	{
		super(frame);
		initialize();
	}

	private void initialize()
	{
		setModal(true);
		setContentPane(getJPanel());
		setTitle("Progress");
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		pack();
		setLocationRelativeTo(getParent());
	}

	private JPanel getJPanel()
	{
		if (jPanel == null)
		{
			jPanel = new JPanel();
			jPanel.setLayout(new GridBagLayout());
			jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
			
			GridBagConstraints c = new GridBagConstraints();
			c.gridx = 0;
			c.gridy = 0;
			c.anchor = GridBagConstraints.LINE_START;
			jPanel.add(getJlDocument(), c);
			
			c.gridy = 1;
			jPanel.add(getJlMessage(), c);
			
			c.gridy = 2;
			c.anchor = GridBagConstraints.CENTER;
			c.insets = new Insets(10, 0, 0, 0);
			jPanel.add(getJProgressBar(), c);
			
			c.gridy = 3;
			c.insets = new Insets(10, 0, 5, 0);
			jPanel.add(getJbCancel(), c);
		}
		return jPanel;
	}
	
	private JLabel getJlDocument()
	{
		if (jlDocument == null)
		{
			jlDocument = new JLabel(" ");
		}
		return jlDocument;
	}
	
	private JLabel getJlMessage()
	{
		if (jlMessage == null)
		{
			jlMessage = new JLabel(" ");
		}
		return jlMessage;
	}
	
	private JProgressBar getJProgressBar()
	{
		if (jProgressBar == null)
		{
			jProgressBar = new JProgressBar();
			jProgressBar.setPreferredSize(new Dimension((int)(250 * SampleUtil.getDPIScalingMultiplier()), (int) jProgressBar.getPreferredSize().getHeight()));
		}
		return jProgressBar;
	}
	
	private JButton getJbCancel()
	{
		if (jbCancel == null)
		{
			jbCancel = new JButton("Stop");
			jbCancel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e)
				{
					isCanceled = true;
				}
			});
		}
		return jbCancel;
	}

	public void progress(final int pageNumber, final int percent, final String message)
	{
		SwingUtilities.invokeLater(new Runnable() {
			public void run()
			{
				getJlMessage().setText(message);
				getJProgressBar().setValue(percent);
			}
		});
	}
	
	public void setDocumentName(final String docName)
	{
		SwingUtilities.invokeLater(new Runnable() {
			public void run()
			{
				getJlDocument().setText("Document: " + docName);
				pack();
			}
		});
	}
	
	public void setIndeterminate(boolean indeterminate)
	{
		getJProgressBar().setIndeterminate(indeterminate);
	}
	
	public boolean isCanceled()
	{
		return isCanceled;
	}

	public boolean shouldCancel()
	{
		return isCanceled;
	}

	@Override
	public void resultAdded(ResultRecord result)
	{
		// TODO Auto-generated method stub
		
	}
}
