package jPDFPreflightSamples;

import java.awt.Dimension;
import java.awt.Frame;

import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class PreflightResultsDialog extends JDialog
{
	private JPanel jpContentPane;
	private JScrollPane jScrollPane;
	
	public PreflightResultsDialog(Frame owner)
	{
		super(owner);
		initialize();
	}
	
	private void initialize()
	{
		setModal(true);
		setResizable(true);
		setContentPane(getJpContentPane());
		setTitle("Preflight");
		pack();
	}
	
	private JPanel getJpContentPane()
	{
		if (jpContentPane == null)
		{
			jpContentPane = new JPanel();
			jpContentPane.setLayout(new BoxLayout(jpContentPane, BoxLayout.Y_AXIS));
			jpContentPane.add(getJScrollPane());
		}
		return jpContentPane;
	}
	
	private JScrollPane getJScrollPane()
	{
		if (jScrollPane == null)
		{
			jScrollPane = new JScrollPane();
			jScrollPane.setPreferredSize(new Dimension((int)(500 * SampleUtil.getDPIScalingMultiplier()), (int)(300 * SampleUtil.getDPIScalingMultiplier())));
		}
		return jScrollPane;
	}
	
	public void setTreeModel(DefaultTreeModel model)
	{
		JTree resultsTree = new JTree(model);

		resultsTree.setRootVisible(false);
		resultsTree.setRowHeight((int)(18 * SampleUtil.getDPIScalingMultiplier()));
		resultsTree.setShowsRootHandles(true);
		IconTreeRenderer renderer = new IconTreeRenderer();
		resultsTree.setCellRenderer(renderer);

		getJScrollPane().setViewportView(resultsTree);
	}
	
}
