package jPDFPreflightSamples;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

import com.qoppa.pdf.DocumentInfo;
import com.qoppa.pdfPreflight.PDFPreflight;
import com.qoppa.pdfPreflight.ProgressListener;
import com.qoppa.pdfPreflight.profiles.ConversionProfile;
import com.qoppa.pdfPreflight.profiles.PDFAConversionOptions;
import com.qoppa.pdfPreflight.profiles.PDFA_1_A_Verification;
import com.qoppa.pdfPreflight.profiles.PDFA_1_B_Conversion;
import com.qoppa.pdfPreflight.profiles.PDFA_1_B_Verification;
import com.qoppa.pdfPreflight.profiles.PDFA_2_B_Conversion;
import com.qoppa.pdfPreflight.profiles.PDFA_2_B_Verification;
import com.qoppa.pdfPreflight.profiles.PDFA_2_U_Verification;
import com.qoppa.pdfPreflight.profiles.PDFA_3_B_Conversion;
import com.qoppa.pdfPreflight.profiles.PDFA_3_B_Verification;
import com.qoppa.pdfPreflight.profiles.PDFA_3_B_ZUGFeRD_Verification;
import com.qoppa.pdfPreflight.profiles.PDFX_1a_2001;
import com.qoppa.pdfPreflight.profiles.PDFX_1a_2003;
import com.qoppa.pdfPreflight.profiles.PDFX_1a_2003_Conversion;
import com.qoppa.pdfPreflight.profiles.PDFX_3_2002;
import com.qoppa.pdfPreflight.profiles.PDFX_3_2003;
import com.qoppa.pdfPreflight.profiles.PDFX_3_Conversion;
import com.qoppa.pdfPreflight.profiles.PDFX_4_Profile;
import com.qoppa.pdfPreflight.profiles.PDFX_4p_Profile;
import com.qoppa.pdfPreflight.profiles.PDFX_5g_Profile;
import com.qoppa.pdfPreflight.profiles.PDFX_5gp_Profile;
import com.qoppa.pdfPreflight.profiles.PDF_UA_Verification;
import com.qoppa.pdfPreflight.profiles.Profile;
import com.qoppa.pdfPreflight.profiles.VerificationProfile;
import com.qoppa.pdfPreflight.results.PreflightReportOptions;
import com.qoppa.pdfPreflight.results.PreflightResults;
import com.qoppa.pdfPreflight.results.ResultRecord;
import com.qoppa.preflight.pdfx.outputintent.NamedCMYKOutputProfile;

public class PDFPreflightPanel extends JPanel implements ActionListener
{
	private JPanel jpTitle;
	private JScrollPane jspRTFDoc;
	private JEditorPane jepRTFPane;
	private JPanel jpAPI;
	private JLabel jlJARLocation;
	private JLabel jlSampleLocation;
	private JButton jbViewAPI;
	private JLabel jlViewAPI;
	private JPanel jpPreflight;
	private JPanel jpPreflightInput;
	private JPanel jpPreflightAction;
	private JComboBox jcbProfile;
	private JRadioButton jrbSingleFile;
	private JRadioButton jrbDirectory;
	private JTextField jtfInputPath;
	private JButton jbBrowseInput;
	private JPanel jpResults;
	private JRadioButton jrbResultsDocument;
	private JRadioButton jrbResultsReport;
	private JTextField jtfOutputPath;
	private JButton jbBrowseOutput;
	private JButton jbVerify;
	private JButton jbConvert;
	private JLabel jlOutputResults;
	private JLabel jlInputPath;
	private JCheckBox jcbFailFast;

	private final static String JAR_FILE_NAME = "jPDFPreflight.jar";
	private final static String API_INDEX_FILENAME = "javadoc/index.html";
	private final static String SAMPLE_DIR_NAME = "jPDFPreflightSamples";

	// Profile options
	private final static String PROFILE_PDFUA = "PDF/UA";
	private final static String PROFILE_PDFA1A = "PDF/A-1a";
	private final static String PROFILE_PDFA1B = "PDF/A-1b";
	private final static String PROFILE_PDFA2B = "PDF/A-2b";
	private final static String PROFILE_PDFA2U = "PDF/A-2u";
	private final static String PROFILE_PDFA3B = "PDF/A-3b";
	private final static String PROFILE_PDFA3B_ZUGFeRD = "PDF/A-3b ZUGFeRD";
	private final static String PROFILE_PDFX_1A_2001 = "PDF/X-1a:2001";
	private final static String PROFILE_PDFX_1A_2003 = "PDF/X-1a:2003";
	private final static String PROFILE_PDFX_3_2002 = "PDF/X-3:2002";
	private final static String PROFILE_PDFX_3_2003 = "PDF/X-3:2003";
	private final static String PROFILE_PDFX_4 = "PDF/X-4";
	private final static String PROFILE_PDFX_4p = "PDF/X-4p";
	private final static String PROFILE_PDFX_5g = "PDF/X-5g";
	private final static String PROFILE_PDFX_5gp = "PDF/X-5gp";

	private final static String[] PROFILES = new String[] {PROFILE_PDFUA, PROFILE_PDFA1A, PROFILE_PDFA1B, PROFILE_PDFA2B, PROFILE_PDFA2U, PROFILE_PDFA3B, PROFILE_PDFA3B_ZUGFeRD, 
			PROFILE_PDFX_1A_2001, PROFILE_PDFX_1A_2003, PROFILE_PDFX_3_2002, PROFILE_PDFX_3_2003, PROFILE_PDFX_4, PROFILE_PDFX_4p, PROFILE_PDFX_5g, PROFILE_PDFX_5gp };

	private static final Map<String, String> m_DefaultFontSubstitutions = new HashMap<String, String>();
	static
	{
		m_DefaultFontSubstitutions.put("Arial", "Arimo");
		m_DefaultFontSubstitutions.put("Cambria", "Caladea");
		m_DefaultFontSubstitutions.put("Calibri", "Carlito");
		m_DefaultFontSubstitutions.put("Courier New", "Cousine");
		m_DefaultFontSubstitutions.put("Times New Roman", "Tinos");
		m_DefaultFontSubstitutions.put("Georgia", "Gelasio");
		m_DefaultFontSubstitutions.put("Symbol", "Symbol Neu");
	}

	public PDFPreflightPanel()
	{
		this(null);
	}

	public PDFPreflightPanel(JPanel apiPanel)
	{
		jpAPI = apiPanel;
		initialize();
	}

	private void initialize()
	{
		// Layout
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

		// Title panel
		add(getjpTitle());
		add(Box.createRigidArea(new Dimension(3, 3)));

		// Add RTF document scroll pane
		add(getjspRTFDoc());
		add(Box.createRigidArea(new Dimension(3, 3)));

		// Add API panel
		add(getjpAPI());
		add(Box.createRigidArea(new Dimension(3, 3)));

		// Add preflight panel
		add(getJpPreflight());
		InputStream stream = getClass().getResourceAsStream("/jPDFPreflight.html");
		if (stream != null)
		{
			try
			{
				getJepRTFPane().setContentType("text/html");

				EditorKit kit = getJepRTFPane().getEditorKit();
				Document doc = kit.createDefaultDocument();
				kit.read(stream, doc, 0);
				stream.close();
				getJepRTFPane().setDocument(doc);
				
				// Standard formatting is horrible, so use some stylesheet properties and system font
				Font font = new java.awt.Font("Dialog", java.awt.Font.PLAIN, new JLabel().getFont().getSize());
				String rule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt;}";
		        ((HTMLDocument)getJepRTFPane().getDocument()).getStyleSheet().addRule(rule);
		        rule = "h3 { font-family: " + font.getFamily() + "; " + "font-size: " + (int)(SampleUtil.getScaledFont(font.getSize(), 20)) + "pt;}";
				((HTMLDocument)getJepRTFPane().getDocument()).getStyleSheet().addRule(rule);
		        rule = "p { margin:0; padding:0;";
		        ((HTMLDocument)getJepRTFPane().getDocument()).getStyleSheet().addRule(rule);
			}
	        catch (Throwable t)
	        {
	            t.printStackTrace();
	        }
		}

		// Initialize help messages
		File jarFile = new File("lib/" + JAR_FILE_NAME);
		getjlJARLocation().setText(JAR_FILE_NAME + " is located at " + jarFile.getAbsolutePath() + ".");
		getjlJARLocation().setToolTipText(jarFile.getAbsolutePath());

		File sampleDir = new File(SAMPLE_DIR_NAME);
		getjlSampleLocation().setText("Sample code is located at " + sampleDir.getAbsolutePath() + ".");
		getjlSampleLocation().setToolTipText(sampleDir.getAbsolutePath());

		// Add action listeners
		getJbViewAPI().addActionListener(this);
		getJcbProfile().addActionListener(this);
		getJbBrowseInput().addActionListener(this);
		getJbBrowseOutput().addActionListener(this);
		getJbVerify().addActionListener(this);
		getJbConvert().addActionListener(this);
		getJrbDirectory().addActionListener(this);
		getJrbSingleFile().addActionListener(this);

		// Enable/disable components
		toggleConvertEnabled();
	}

	private JPanel getjpTitle()
	{
		if (jpTitle == null)
		{
			jpTitle = new JPanel();
			JLabel jlTitle = new JLabel(PDFPreflight.getVersion());
			jlTitle.setFont(new Font("dialog", Font.BOLD, (int)SampleUtil.getScaledFont(jlTitle.getFont().getSize(), 14)));
			jpTitle.add(jlTitle);
			jpTitle.setPreferredSize(new Dimension((int)(700 * SampleUtil.getDPIScalingMultiplier()), (int)(30 * SampleUtil.getDPIScalingMultiplier())));
			jpTitle.setMaximumSize(new Dimension(jpTitle.getMaximumSize().width, (int)(30 * SampleUtil.getDPIScalingMultiplier())));
			jpTitle.setBorder(new EtchedBorder());
		}
		return jpTitle;
	}

	private JScrollPane getjspRTFDoc()
	{
		if (jspRTFDoc == null)
		{
			jspRTFDoc = new JScrollPane();
			jspRTFDoc.setPreferredSize(new Dimension((int)(681 * SampleUtil.getDPIScalingMultiplier()), (int)(220 * SampleUtil.getDPIScalingMultiplier())));
			jspRTFDoc.setViewportView(getJepRTFPane());
		}
		return jspRTFDoc;
	}

	private JPanel getjpAPI()
	{
		if (jpAPI == null)
		{
			jpAPI = new JPanel();
			jpAPI.setBorder(javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.LOWERED));

			jpAPI.setLayout(new GridBagLayout());
			GridBagConstraints c = new GridBagConstraints();
			c.anchor = GridBagConstraints.FIRST_LINE_START;
			c.weightx = 1;
			c.insets = new Insets(0, 10, 5, 0);

			c.gridx = 0;
			c.gridy = 0;
			c.gridwidth = 2;
			jpAPI.add(getjlJARLocation(), c);

			c.gridx = 0;
			c.gridy = 1;
			c.gridwidth = 2;
			jpAPI.add(getjlSampleLocation(), c);

			c.weightx = 0;
			c.gridx = 0;
			c.gridy = 2;
			c.gridwidth = 1;
			jpAPI.add(getJbViewAPI(), c);

			c.weightx = 1;
			c.gridx = 1;
			c.gridy = 2;
			c.gridwidth = 1;
			jpAPI.add(getJlViewAPI(), c);
		}
		return jpAPI;
	}

	private JLabel getJlViewAPI()
	{
		if (jlViewAPI == null)
		{
			jlViewAPI = new JLabel("to view the API.");
			jlViewAPI.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jlViewAPI.getFont().getSize(), 12)));
		}
		return jlViewAPI;
	}

	private JEditorPane getJepRTFPane()
	{
		if (jepRTFPane == null)
		{
			jepRTFPane = new JEditorPane() {
				public void paint(Graphics g)
				{
					Graphics2D g2d = (Graphics2D) g;
					g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
					g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
					super.paint(g);
				}
			};
			jepRTFPane.setEditable(false);
			jepRTFPane.setBackground(Color.white);
		}
		return jepRTFPane;
	}

	private JButton getJbViewAPI()
	{
		if (jbViewAPI == null)
		{
			jbViewAPI = new JButton("View API");
		}
		return jbViewAPI;
	}

	private JLabel getjlJARLocation()
	{
		if (jlJARLocation == null)
		{
			jlJARLocation = new JLabel();
			jlJARLocation.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jlJARLocation.getFont().getSize(), 12)));
		}
		return jlJARLocation;
	}

	private JLabel getjlSampleLocation()
	{
		if (jlSampleLocation == null)
		{
			jlSampleLocation = new JLabel();
			jlSampleLocation.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jlSampleLocation.getFont().getSize(), 12)));
		}
		return jlSampleLocation;
	}

	private void viewAPI()
	{
		try
		{
			File apiIndex = new File(API_INDEX_FILENAME);
			if (isSystemWindows())
			{
				Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + apiIndex.getAbsolutePath());
			}
			else if (isSystemMac())
			{
				String[] cmdArray = new String[2];
				cmdArray[0] = "open";
				cmdArray[1] = apiIndex.getAbsolutePath();
				Runtime.getRuntime().exec(cmdArray);
			}
			// assume Unix or Linux
			else
			{
				String[] browsers = { "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape", "google-chrome" };
				String browser = null;
				for (int count = 0; count < browsers.length; count++)
				{
					if (Runtime.getRuntime().exec(new String[] { "which", browsers[count] }).waitFor() == 0)
					{
						browser = browsers[count];
						break;
					}
				}
				if (browser == null)
				{
					throw new Exception("Could not find web browser");
				}
				else
				{
					Runtime.getRuntime().exec(new String[] { browser, apiIndex.getAbsolutePath() });
				}
			}
		}
		catch (Throwable t)
		{
			javax.swing.JOptionPane.showMessageDialog(this, t.getMessage());
		}
	}

	private boolean isSystemMac()
	{
		// Check the OS
		String osName = System.getProperty("os.name").toLowerCase();
		return osName.indexOf("mac") != -1;
	}

	private boolean isSystemWindows()
	{
		// Check the OS
		String osName = System.getProperty("os.name").toLowerCase();
		return osName.startsWith("windows");
	}

	private JPanel getJpPreflight()
	{
		if (jpPreflight == null)
		{
			jpPreflight = new JPanel();
			jpPreflight.setLayout(new GridBagLayout());
			jpPreflight.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED), "Sample Processing", TitledBorder.DEFAULT_JUSTIFICATION,
					TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(new JLabel().getFont().getSize(), 12)), Color.black));

			GridBagConstraints c = new GridBagConstraints();
			c.anchor = GridBagConstraints.LINE_START;
			c.fill = GridBagConstraints.HORIZONTAL;
			c.weightx = 1;
			c.weighty = 1;
			c.gridx = 0;
			c.gridy = 0;
			jpPreflight.add(getJpPreflightInput(), c);

			c.gridx = 0;
			c.gridy = 1;
			jpPreflight.add(getJpResults(), c);

			c.anchor = GridBagConstraints.LINE_END;
			c.gridx = 0;
			c.gridy = 2;
			jpPreflight.add(getJpPreflightAction(), c);
		}
		return jpPreflight;
	}

	private JPanel getJpPreflightInput()
	{
		if (jpPreflightInput == null)
		{
			jpPreflightInput = new JPanel(new GridBagLayout());

			GridBagConstraints c = new GridBagConstraints();
			c.anchor = GridBagConstraints.LINE_START;
			c.gridx = 0;
			c.gridy = 0;
			JLabel jlSelect = new JLabel("Select Preflight Profile:");
			jlSelect.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jlSelect.getFont().getSize(), 12)));
			jpPreflightInput.add(jlSelect, c);

			JPanel panel1 = new JPanel();
			panel1.add(getJcbProfile(), c);

			ButtonGroup bg = new ButtonGroup();
			bg.add(getJrbSingleFile());
			bg.add(getJrbDirectory());
			getJrbSingleFile().setSelected(true);

			panel1.add(getJrbSingleFile(), c);
			panel1.add(getJrbDirectory(), c);

			c.gridx = 1;
			c.gridy = 0;
			jpPreflightInput.add(panel1, c);

			c.gridx = 0;
			c.gridy = 1;
			jpPreflightInput.add(getJlInputPath(), c);

			c.weightx = 1;
			c.gridx = 1;
			c.gridy = 1;
			c.fill = GridBagConstraints.HORIZONTAL;
			jpPreflightInput.add(getJtfInputPath(), c);

			c.weightx = 0;
			c.gridx = 2;
			c.gridy = 1;
			c.fill = GridBagConstraints.NONE;
			c.ipadx = 10;
			c.insets = new Insets(0, 10, 0, 50);
			jpPreflightInput.add(getJbBrowseInput(), c);
		}
		return jpPreflightInput;
	}
	
	private JLabel getJlInputPath()
	{
		if (jlInputPath == null)
		{
			jlInputPath = new JLabel("File Path:");
			jlInputPath.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jlInputPath.getFont().getSize(), 12)));
		}
		return jlInputPath;
	}

	private JPanel getJpPreflightAction()
	{
		if (jpPreflightAction == null)
		{
			jpPreflightAction = new JPanel(new GridBagLayout());

			GridBagConstraints c = new GridBagConstraints();
			c.anchor = GridBagConstraints.LINE_END;

			JLabel jlDemoMode = new JLabel("Watermark added in Demo Mode");
			jlDemoMode.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jlDemoMode.getFont().getSize(), 12)));
			jlDemoMode.setForeground(Color.red);
			c.weightx = 1;
			c.gridx = 0;
			jpPreflightAction.add(jlDemoMode, c);

			c.weightx = 0;
			c.gridx = 1;
			c.insets = new Insets(5, 10, 5, 10);
			jpPreflightAction.add(getJbVerify(), c);

			c.gridx = 2;
			jpPreflightAction.add(getJbConvert(), c);
			
			c.gridx = 3;
			jpPreflightAction.add(getJcbFailFast(), c);
		}
		return jpPreflightAction;
	}

	private JComboBox getJcbProfile()
	{
		if (jcbProfile == null)
		{
			jcbProfile = new JComboBox(PROFILES);
			jcbProfile.setPreferredSize(new Dimension((int)(200 * SampleUtil.getDPIScalingMultiplier()), (int) jcbProfile.getPreferredSize().getHeight()));
			jcbProfile.setSelectedItem(PROFILE_PDFA1B);
		}
		return jcbProfile;
	}

	private JRadioButton getJrbSingleFile()
	{
		if (jrbSingleFile == null)
		{
			jrbSingleFile = new JRadioButton("Single File");
			jrbSingleFile.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jrbSingleFile.getFont().getSize(), 12)));
		}
		return jrbSingleFile;
	}

	private JRadioButton getJrbDirectory()
	{
		if (jrbDirectory == null)
		{
			jrbDirectory = new JRadioButton("Directory");
			jrbDirectory.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jrbDirectory.getFont().getSize(), 12)));
		}
		return jrbDirectory;
	}
	
	private JCheckBox getJcbFailFast()
	{
		if (jcbFailFast == null)
		{
			jcbFailFast = new JCheckBox("Fail Fast");
			jcbFailFast.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jcbFailFast.getFont().getSize(), 12)));
		}
		return jcbFailFast;
	}

	private JTextField getJtfInputPath()
	{
		if (jtfInputPath == null)
		{
			jtfInputPath = new JTextField();
		}
		return jtfInputPath;
	}

	private JButton getJbBrowseInput()
	{
		if (jbBrowseInput == null)
		{
			jbBrowseInput = new JButton("Open");
		}
		return jbBrowseInput;
	}

	private JButton getJbVerify()
	{
		if (jbVerify == null)
		{
			jbVerify = new JButton("Verify");
		}
		return jbVerify;
	}

	private JButton getJbConvert()
	{
		if (jbConvert == null)
		{
			jbConvert = new JButton("Convert");
		}
		return jbConvert;
	}

	private JPanel getJpResults()
	{
		if (jpResults == null)
		{
			jpResults = new JPanel(new GridBagLayout());
			jpResults.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED), "Results", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION,
					new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(new JLabel().getFont().getSize(), 12)), Color.black));

			GridBagConstraints c1 = new GridBagConstraints();
			c1.anchor = GridBagConstraints.LINE_START;
			c1.weightx = 1;

			ButtonGroup bg = new ButtonGroup();
			bg.add(getJrbResultsDocument());
			bg.add(getJrbResultsReport());
			getJrbResultsDocument().setSelected(true);

			JPanel panel1 = new JPanel();
			panel1.add(getJrbResultsDocument());
			panel1.add(getJrbResultsReport());
			c1.gridx = 0;
			c1.gridy = 0;
			c1.insets = new Insets(0, 0, 0, 0);
			jpResults.add(panel1, c1);

			JPanel panel2 = new JPanel(new GridBagLayout());
			GridBagConstraints c2 = new GridBagConstraints();
			c2.fill = GridBagConstraints.HORIZONTAL;
			c2.insets = new Insets(0, 5, 5, 0);
			c2.gridx = 0;
			c2.gridy = 0;
			panel2.add(getJlOutputResults(), c2);

			c2.weightx = 1;
			c2.gridx = 1;
			c2.gridy = 0;
			panel2.add(getJtfOutputPath(), c2);

			c2.insets = new Insets(0, 5, 5, 30);
			c2.weightx = 0;
			c2.gridx = 2;
			c2.gridy = 0;
			panel2.add(getJbBrowseOutput(), c2);

			c2.gridwidth = 2;
			c2.gridx = 1;
			c2.gridy = 1;
			panel2.add(new JLabel("*Verify results will go in Compliant/Not Compliant sub folders; Convert results in Converted/Not Converted sub folders"), c2);

			c1.fill = GridBagConstraints.HORIZONTAL;
			c1.gridx = 0;
			c1.gridy = 1;
			jpResults.add(panel2, c1);
		}
		return jpResults;
	}

	private JLabel getJlOutputResults()
	{
		if (jlOutputResults == null)
		{
			jlOutputResults = new JLabel("Output Results To:");
			jlOutputResults.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jlOutputResults.getFont().getSize(), 12)));
		}
		return jlOutputResults;
	}

	private JRadioButton getJrbResultsDocument()
	{
		if (jrbResultsDocument == null)
		{
			jrbResultsDocument = new JRadioButton("Original PDF with report and annotations");
			jrbResultsDocument.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jrbResultsDocument.getFont().getSize(), 12)));
		}
		return jrbResultsDocument;
	}

	private JRadioButton getJrbResultsReport()
	{
		if (jrbResultsReport == null)
		{
			jrbResultsReport = new JRadioButton("Report only");
			jrbResultsReport.setFont(new java.awt.Font("Dialog", java.awt.Font.PLAIN, (int)SampleUtil.getScaledFont(jrbResultsReport.getFont().getSize(), 12)));
		}
		return jrbResultsReport;
	}

	private JTextField getJtfOutputPath()
	{
		if (jtfOutputPath == null)
		{
			jtfOutputPath = new JTextField();
		}
		return jtfOutputPath;
	}

	private JButton getJbBrowseOutput()
	{
		if (jbBrowseOutput == null)
		{
			jbBrowseOutput = new JButton("Browse...");
		}
		return jbBrowseOutput;
	}

	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == getJbViewAPI())
		{
			// Show API in the browser
			viewAPI();
		}
		else if (e.getSource() == getJcbProfile())
		{
			// Enable/disable conversion option
			toggleConvertEnabled();
		}
		else if (e.getSource() == getJbBrowseInput())
		{
			// Show file chooser for input file(s)
			File inputFile = showFileChooser(new File(getJtfInputPath().getText()), getJrbDirectory().isSelected());
			if (inputFile != null)
			{
				getJtfInputPath().setText(inputFile.getAbsolutePath());
				getJtfOutputPath().setText(getJrbDirectory().isSelected() ? inputFile.getAbsolutePath() : inputFile.getParent());
			}
		}
		else if (e.getSource() == getJbBrowseOutput())
		{
			// Show file chooser for report output
			File outputFile = showFileChooser(new File(getJtfOutputPath().getText()), true);
			if (outputFile != null)
			{
				getJtfOutputPath().setText(outputFile.getAbsolutePath());
			}
		}
		else if (e.getSource() == getJbVerify())
		{
			// Get the input files
			File[] inputFiles = getInputFiles();
			if (inputFiles == null)
			{
				getJtfInputPath().requestFocus();
				return;
			}

			// Get the output directory
			File outputFile = new File(getJtfOutputPath().getText());
			if (outputFile.exists())
			{
				if (!outputFile.isDirectory())
				{
					JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Ouput directory does not exist " + getJtfOutputPath().getText(), null, JOptionPane.ERROR_MESSAGE);
					getJtfOutputPath().requestFocus();
					return;
				}
			}
			else
			{
				if(!outputFile.mkdirs())
				{
					JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Unable to create output directory " + getJtfOutputPath().getText(), null, JOptionPane.ERROR_MESSAGE);
					getJtfOutputPath().requestFocus();
					return;
				}
			}
			
			
			Profile profile = getSelectedProfile();
			
			JCheckBox failFast = getJcbFailFast();
			
			// Run the verification
			runVerification(inputFiles, outputFile, profile, failFast.isSelected());
		}
		else if (e.getSource() == getJbConvert())
		{
			File[] files = getInputFiles();
			if (files == null)
			{
				getJtfInputPath().requestFocus();
				return;
			}

			// Get the output directory
			File outputFile = new File(getJtfOutputPath().getText());
			if (outputFile.exists())
			{
				if (!outputFile.isDirectory())
				{
					JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Ouput directory does not exist " + getJtfOutputPath().getText(), null, JOptionPane.ERROR_MESSAGE);
					getJtfOutputPath().requestFocus();
					return;
				}
			}
			else
			{
				if(!outputFile.mkdirs())
				{
					JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Unable to create output directory " + getJtfOutputPath().getText(), null, JOptionPane.ERROR_MESSAGE);
					getJtfOutputPath().requestFocus();
					return;
				}
			}
			
			JCheckBox failFast = getJcbFailFast();
			// Run the conversion
			runConversion(files, outputFile, failFast.isSelected());
		}
		else if (e.getSource() == getJrbDirectory())
		{
			if (getJrbDirectory().isSelected())
			{
				getJlInputPath().setText("Directory Path:");
				saveText(getJrbSingleFile());
				loadText(getJrbDirectory());
			}
		}
		else if (e.getSource() == getJrbSingleFile())
		{
			if (getJrbSingleFile().isSelected())
			{
				getJlInputPath().setText("File Path:");
				saveText(getJrbDirectory());
				loadText(getJrbSingleFile());
			}
		}
	}

	private Object VALUE = new Object();
	private void saveText(JRadioButton jrb)
	{
		if (getJtfInputPath().getText() != null && getJtfInputPath().getText().length() > 0)
		{
			jrb.putClientProperty(VALUE, getJtfInputPath().getText());
		}
		else
		{
			jrb.putClientProperty(VALUE, null);
		}
	}

	private void loadText(JRadioButton jrb)
	{
		if (jrb.getClientProperty(VALUE) != null)
		{
			getJtfInputPath().setText(String.valueOf(jrb.getClientProperty(VALUE)));
		}
		else
		{
			getJtfInputPath().setText(null);
		}
		getJtfInputPath().requestFocus();
	}

	private File[] getInputFiles()
	{
		File file = new File(getJtfInputPath().getText());
		if (getJrbDirectory().isSelected())
		{
			if (!file.isDirectory())
			{
				JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Input directory does not exist " + getJtfInputPath().getText(), null, JOptionPane.ERROR_MESSAGE);
				return null;
			}
			File[] files = file.listFiles(new PDFFileFilter());
			if (files.length < 1)
			{
				JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Input directory does not contain PDF files " + getJtfInputPath().getText(), null, JOptionPane.ERROR_MESSAGE);
				return null;
			}
			return files;
		}
		else
		{
			if (!file.exists())
			{
				JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Input file does not exist " + getJtfInputPath().getText(), null, JOptionPane.ERROR_MESSAGE);
				return null;
			}
			if (!"pdf".equalsIgnoreCase(PDFFileFilter.getExtension(file)))
			{
				JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this), "Input file extension is not .pdf " + getJtfInputPath().getText(), null, JOptionPane.ERROR_MESSAGE);
				return null;
			}
			return new File[] { file };
		}
	}

	private void toggleConvertEnabled()
	{
		boolean enable = getJcbProfile().getSelectedItem() == PROFILE_PDFA1B 
				|| getJcbProfile().getSelectedItem() == PROFILE_PDFA2B 
				|| getJcbProfile().getSelectedItem() == PROFILE_PDFA3B
				|| getJcbProfile().getSelectedItem() == PROFILE_PDFX_1A_2003
				|| getJcbProfile().getSelectedItem() == PROFILE_PDFX_3_2003;
		getJbConvert().setEnabled(enable);
	}

	private File showFileChooser(File selectedFile, boolean directortiesOnly)
	{
		JFileChooser fileChooser = new JFileChooser();
		if (directortiesOnly)
		{
			fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		}
		else
		{
			fileChooser.setFileFilter(new PDFFileFilter());
		}

		// Set selected file
		fileChooser.setSelectedFile(selectedFile);

		// Show file chooser dialog
		if (fileChooser.showOpenDialog(SwingUtilities.windowForComponent(this)) != JFileChooser.APPROVE_OPTION)
		{
			return null;
		}
		return fileChooser.getSelectedFile();
	}

	private void runVerification(final File[] files, final File outFile, final Profile profile, final boolean failFast)
	{
		final ProgressDialog pd = new ProgressDialog((Frame) SwingUtilities.windowForComponent(this));
		pd.setIndeterminate(profile instanceof PDFA_1_B_Verification);
		
		pd.addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e)
			{
				Thread thread = new Thread(new Runnable() {
					public void run()
					{
						final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
						final List errorList = new Vector();
						int successes = 0;
						int fails = 0;
						
						// Directories to output the results
						File compliantDir = new File(outFile.getAbsolutePath() + File.separator + "Compliant");
						File errorReportDir = new File(outFile.getAbsolutePath() + File.separator + "Not Compliant");
						try
						{
							for (int i = 0; i < files.length && !pd.isCanceled(); i++)
							{
								if (files[i].isDirectory())
								{
									continue;
								}
								
								try
								{
									pd.setDocumentName(files[i].getName());
									
									// Load the PDF Document
									PDFPreflight pdfPreflight = new PDFPreflight(files[i].getAbsolutePath(), null);
									
									ProgressListener progressListener = null;
									if (failFast)
									{
										
										progressListener = new ProgressListener(){

											private boolean shouldCancel = false;
											@Override
											public void progress(int pageNumber, int percent, String message)
											{
												pd.progress(pageNumber, percent, message);
												
											}

											@Override
											public boolean shouldCancel()
											{
												if (shouldCancel)
												{
													return true;
												}
												else
												{
													return pd.shouldCancel();
												}
											}

											@Override
											public void resultAdded(ResultRecord result)
											{
												shouldCancel = true;
												
											}
											
										};
									}
									else
									{
										progressListener = pd;
									}
									// Validate the document
									PreflightResults results = pdfPreflight.verifyDocument((VerificationProfile) profile, progressListener);
									
									// Create the results node
									IconTreeNode iconNode = createResultsNode(results, files[i].getName(), profile, pdfPreflight.getDocumentInfo());
									
									// Add the node to the root node
									rootNode.add(iconNode);
									
									if (results.isSuccessful())
									{
										// Create output directory if needed
										if (!compliantDir.exists())
										{
											compliantDir.mkdir();
										}
										
										// Avoid overwriting existing files
										File outputFile = createUniqueFileName(new File(compliantDir.getAbsolutePath(), getFileNameWithoutExt(files[i]) + "_" + makeFileFriendly(getJcbProfile().getSelectedItem()) + ".pdf"));
										
										// Save the PDF Document
										pdfPreflight.saveDocument(outputFile.getAbsolutePath());
									}
									else
									{
										// Create output directory if needed
										if (!errorReportDir.exists())
										{
											errorReportDir.mkdir();
										}
										
										// Avoid overwriting existing files
										File outputFile = createUniqueFileName(new File(errorReportDir.getAbsolutePath(), getFileNameWithoutExt(files[i]) + "_" + makeFileFriendly(getJcbProfile().getSelectedItem()) + "Report.pdf"));
										
										if (getJrbResultsDocument().isSelected())
										{
											try
											{
												// Add annotations to the document
												pdfPreflight.addResultAnnotations(results);
											}
											catch (Exception e)
											{
												errorList.add(files[i].getName() + ": Permissions do not allow annotating results");
											}

											try
											{
												// Append report to the document
												pdfPreflight.appendPreflightReport(results, 612, 792); 
											}
											catch (Exception e)
											{
												errorList.add(files[i].getName() + ": Permissions do not allow appending results");
											}
																					
											// Save the PDF document
											pdfPreflight.saveDocument(outputFile.getAbsolutePath());
										}
										else
										{
											// Save the preflight report
											results.savePreflightReport(outputFile.getAbsolutePath(), 612, 792, new PreflightReportOptions());
										}
									}								
									successes++;
								}
								catch (Throwable t)
								{
									t.printStackTrace();
									fails++;
									errorList.add(files[i].getName() + ": " + (t.getMessage() != null ? t.getMessage() : "error"));
								}
							}
						}
						finally
						{
							final int finalSuccesses = successes;
							final int finalFails = fails;
							SwingUtilities.invokeLater(new Runnable() {
								public void run()
								{
									pd.dispose();

									// Show dialog with error messages
									if (errorList.size() > 0)
									{
										showErrorDialog(errorList, finalSuccesses, finalFails);
									}

									// Show the results
									if (finalSuccesses > 0)
									{
										DefaultTreeModel model = new DefaultTreeModel(rootNode);
										showResults(model);
									}
									
								}
							});
						}
					}
				});
				thread.start();
			}
		});
		pd.setVisible(true);
	}
	
	private void showErrorDialog(List errorList, int successes, int fails)
	{
		ErrorDialog errorDialog = new ErrorDialog((Frame) SwingUtilities.windowForComponent(PDFPreflightPanel.this));
		errorDialog.setSuccesCount(successes);
		errorDialog.setErrorCount(fails);
		errorDialog.setErrorMessages(errorList);
		
		errorDialog.showDialog();
	}
	
	private String getFileNameWithoutExt(File file)
	{
		return file.getName().substring(0, file.getName().lastIndexOf("."));
	}
	
	private File createUniqueFileName(File file)
	{
		File ret = file;
        for (int i = 1; ret.exists(); i++)
        {
        	ret = new File(file.getParent(), getFileNameWithoutExt(file) + "_" + i + ".pdf");
        }
    	return ret;
	}

	private Profile getSelectedProfile()
	{
		Object item = getJcbProfile().getSelectedItem();
		Profile profile;
		if (item == PROFILE_PDFX_1A_2001)
		{
			profile = new PDFX_1a_2001();
		}
		else if (item == PROFILE_PDFX_1A_2003)
		{
			profile = new PDFX_1a_2003();
		}
		else if (item == PROFILE_PDFX_3_2002)
		{
			profile = new PDFX_3_2002();
		}
		else if (item == PROFILE_PDFX_3_2003)
		{
			profile = new PDFX_3_2003();
		}
		else if (item == PROFILE_PDFX_4)
		{
			profile = new PDFX_4_Profile();
		}
		else if (item == PROFILE_PDFX_4p)
		{
			profile = new PDFX_4p_Profile();
		}
		else if (item == PROFILE_PDFX_5g)
		{
			profile = new PDFX_5g_Profile();
		}
		else if (item == PROFILE_PDFX_5gp)
		{
			profile = new PDFX_5gp_Profile();
		}
		else if (item == PROFILE_PDFA1A)
		{
			profile = new PDFA_1_A_Verification();
		}
		else if (item == PROFILE_PDFA2B)
		{
			profile = new PDFA_2_B_Verification();
		}
		else if (item == PROFILE_PDFA2U)
		{
			profile = new PDFA_2_U_Verification();
		}
		else if (item == PROFILE_PDFA3B)
		{
			profile = new PDFA_3_B_Verification();
		}
		else if (item == PROFILE_PDFA3B_ZUGFeRD)
		{
			profile = new PDFA_3_B_ZUGFeRD_Verification();
		}
		else if (item == PROFILE_PDFUA)
		{
			profile = new PDF_UA_Verification();
		}
		else
		{
			profile = new PDFA_1_B_Verification();
		}
		return profile;
	}

	private Profile getSelectedConversionProfile()
	{
		Object item = getJcbProfile().getSelectedItem();
		Profile profile;
		if (item == PROFILE_PDFA2B)
		{
			profile = new PDFA_2_B_Conversion();
		}
		else if (item == PROFILE_PDFA3B)
		{
			profile = new PDFA_3_B_Conversion();
		}
		else if (item == PROFILE_PDFX_1A_2003)
		{
			profile = new PDFX_1a_2003_Conversion(NamedCMYKOutputProfile.getDefaultProfile().profile);
		}
		else if (item == PROFILE_PDFX_3_2003)
		{
			profile = new PDFX_3_Conversion(NamedCMYKOutputProfile.getDefaultProfile().profile);
		}
		else
		{
			profile = new PDFA_1_B_Conversion();
		}
		return profile;
	}

	private String makeFileFriendly(Object comboResults)
	{
		String name = comboResults.toString();
		return name.replace('/', '_').replace(':', '_');
	}

	private void runConversion(final File[] files, final File outFile, final boolean failFast)
	{
		final Profile profile = getSelectedConversionProfile();
		final ProgressDialog pd = new ProgressDialog((Frame) SwingUtilities.windowForComponent(this));
		pd.setIndeterminate(true);

		pd.addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e)
			{
				Thread thread = new Thread(new Runnable() {
					public void run()
					{
						final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
						final List errorList = new Vector();
						int successes = 0;
						int fails = 0;

						// Directories to output the results
						final File convertedDir = new File(outFile.getAbsolutePath() + File.separator + "Converted");
						File errorReportDir = new File(outFile.getAbsolutePath() + File.separator + "Not Converted");
						try
						{
							for (int i = 0; i < files.length && !pd.isCanceled(); i++)
							{
								if (files[i].isDirectory())
								{
									continue;
								}
								
								try
								{
									pd.setDocumentName(files[i].getName());
									
									// Load the PDF Document
									PDFPreflight pdfPreflight = new PDFPreflight(files[i].getAbsolutePath(), null);
									
									ProgressListener progressListener = null;
									if (failFast)
									{
										
										progressListener = new ProgressListener(){

											private boolean shouldCancel = false;
											@Override
											public void progress(int pageNumber, int percent, String message)
											{
												pd.progress(pageNumber, percent, message);
												
											}

											@Override
											public boolean shouldCancel()
											{
												if (shouldCancel)
												{
													return true;
												}
												else
												{
													return pd.shouldCancel();
												}
											}

											@Override
											public void resultAdded(ResultRecord result)
											{
												if (!result.willFix() || !result.isFixable())
												{
													shouldCancel = true;
												}
												
											}
											
										};
									}
									else
									{
										progressListener = pd;
									}

									if (profile.getConversionOptions() instanceof PDFAConversionOptions)
									{
										//font substitutions
										for (String family : m_DefaultFontSubstitutions.keySet())
										{
											String sub = m_DefaultFontSubstitutions.get(family);
											((PDFAConversionOptions)profile.getConversionOptions()).setFontSubstitute(family, sub, false);
										}
									}

									// Convert the document
									PreflightResults results = pdfPreflight.convertDocument((ConversionProfile)profile, progressListener);

									// Create the results node
									IconTreeNode iconNode = createResultsNode(results, files[i].getName(), profile, pdfPreflight.getDocumentInfo());

									// Add the node to the root node
									rootNode.add(iconNode);
									
									if (results.isSuccessful())
									{
										// Create output directory if needed
										if (!convertedDir.exists())
										{
											convertedDir.mkdir();
										}
										
										// Avoid overwriting existing files
										File outputFile = createUniqueFileName(new File(convertedDir.getAbsolutePath(), getFileNameWithoutExt(files[i]) + "_" + makeFileFriendly(getJcbProfile().getSelectedItem()) + ".pdf"));

										// Save the PDF Document
										pdfPreflight.saveDocument(outputFile.getAbsolutePath());
									}
									else
									{
										// Create output directory if needed
										if (!errorReportDir.exists())
										{
											errorReportDir.mkdir();
										}
										
										// Avoid overwriting existing files
										File outputFile = createUniqueFileName(new File(errorReportDir.getAbsolutePath(), getFileNameWithoutExt(files[i]) + "_" + makeFileFriendly(getJcbProfile().getSelectedItem()) + "Report.pdf"));
										
										if (getJrbResultsDocument().isSelected())
										{
											try
											{
												// Add annotations to the document
												pdfPreflight.addResultAnnotations(results);
											}
											catch (Exception e)
											{
												errorList.add(files[i].getName() + ": Permissions do not allow annotating results");
											}

											try
											{
												// Append report to the document
												pdfPreflight.appendPreflightReport(results, 612, 792); 
											}
											catch (Exception e)
											{
												errorList.add(files[i].getName() + ": Permissions do not allow appending results");
											}

											// Save the PDF document
											pdfPreflight.saveDocument(outputFile.getAbsolutePath());
										}
										else
										{
											// Save the problem report
											results.savePreflightReport(outputFile.getAbsolutePath(), 612, 792, new PreflightReportOptions());
										}
										
										errorList.add(files[i].getName() + ": Unable to convert document");
									}

									successes++;
								}
								catch (Throwable t)
								{
									t.printStackTrace();
									errorList.add(files[i].getName() + ": " + (t.getMessage() != null ? t.getMessage() : "error"));
									fails++;
								}
							}
						}
						finally
						{
							final int finalSuccesses = successes;
							final int finalFails = fails;
							SwingUtilities.invokeLater(new Runnable() {
								public void run()
								{
									pd.dispose();

									// Show dialog with error messages
									if (errorList.size() > 0)
									{
										showErrorDialog(errorList, finalSuccesses, finalFails);
									}

									// Show the results
									if (finalSuccesses > 0)
									{
										if (finalSuccesses > errorList.size())
										{
											JOptionPane.showMessageDialog(PDFPreflightPanel.this, "Successfully converted files can be found in " + convertedDir.getAbsolutePath());
										}

										DefaultTreeModel model = new DefaultTreeModel(rootNode);
										showResults(model);
									}
								}
							});
						}
					}
				});
				thread.start();
			}
		});
		pd.setVisible(true);
	}
	
	private IconTreeNode createResultsNode(PreflightResults results, String docName, Profile profile, DocumentInfo docInfo)
	{
		// Create the results tree
		DefaultMutableTreeNode resultsNode = PreflightResultsTreeFactory.createResultsTree(results, profile, profile instanceof ConversionProfile, getJbConvert().isEnabled(), docInfo);
		
		// Create the document node
		IconTreeNode iconNode = null;
		if (results.isSuccessful())
		{
			iconNode = new IconTreeNode(docName, PreflightResultsTreeFactory.CHECKMARK_ICON);
		}
		else
		{
			iconNode = new IconTreeNode(docName, PreflightResultsTreeFactory.ERROR_ICON);
		}
		
		// Add the results tree to the document node
		while (resultsNode.getChildCount() > 0)
		{
			iconNode.add((MutableTreeNode) resultsNode.getChildAt(0));
		}
		
		return iconNode;
	}

	private void showResults(DefaultTreeModel model)
	{
		// Show the results dialog
		PreflightResultsDialog resultsDialog = new PreflightResultsDialog((Frame) SwingUtilities.windowForComponent(this));
		resultsDialog.setTreeModel(model);

		resultsDialog.setLocationRelativeTo(SwingUtilities.windowForComponent(this));
		resultsDialog.setVisible(true);
	}
	
}
