package jPDFPreflightSamples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import com.qoppa.pdf.FontSettings;
import com.qoppa.pdfPreflight.PDFPreflight;

public class PDFPreflightFrame extends JFrame
{
	public PDFPreflightFrame()
	{
		initialize();
	}

	private void initialize()
	{
		setContentPane(new PDFPreflightPanel());
		setTitle("jPDFPreflight Sample - " + PDFPreflight.getVersion());
		setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
		pack();
		setLocationRelativeTo(null);
		
        try
		{
    		// Try to set multiple images, java 1.6 only
			Method setIconImages = getClass().getMethod("setIconImages", new Class[] {List.class});
			Vector imageList = new Vector();
			imageList.add(ImageIO.read(getClass().getResourceAsStream("jPDFPreflight16.png")));
			imageList.add(ImageIO.read(getClass().getResourceAsStream("jPDFPreflight32.png")));
			setIconImages.invoke(this, new Object[] {imageList});
		}
		catch (Throwable t1)
		{
			try
	        {
	            setIconImage(ImageIO.read(getClass().getResourceAsStream("jPDFPreflight16.png")));
	        }
	        catch(Throwable t2)
	        {
	        }
		}
	}

	public static void main(String[] args)
	{
		try
		{
			// Create a log file in the user's home directory
			File outFile = new File(System.getProperty("user.home") + File.separator + "jpdfpreflight.log");
			PrintStream out = new PrintStream(new FileOutputStream(outFile));
			System.setOut(out);
			System.setErr(out);
			
			// Initial log information
			SampleUtil.libraryLogStart(PDFPreflight.class);			
		}
		catch (Throwable t)
		{
			// Continue without log file
		}

		// Set the look and feel
		try
		{
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}
		catch (Throwable t)
		{
		}
		
		// When rendering, use a substitute font when the specified font cannot
		// be found, or the is an error with the embedded font, otherwise the
		// document will not be rendered and an exception will be thrown.
		FontSettings.setUseSubstituteFont(true);

		// Initialize the user font directory for font embedding
		initUserFontDirectories();

		SwingUtilities.invokeLater(new Runnable(){
			public void run()
			{
				// Create and show the frame
				PDFPreflightFrame frame = new PDFPreflightFrame();
				frame.setVisible(true);
			}
		});
	}
	
	private static void initUserFontDirectories()
	{
		// Set the user font directory for embedding
		File fontDir = new File("fonts");
		if (fontDir.exists())
		{
			List<String> userFontDirs = new ArrayList<String>();
			userFontDirs.add(fontDir.getAbsolutePath());
			FontSettings.setUserFontDirectories(userFontDirs);
		}
	}
}
