package jPDFPreflightSamples;

import java.io.File;

import javax.swing.filechooser.FileFilter;

public class PDFFileFilter extends FileFilter implements java.io.FileFilter
{
	private final static String PDF_EXTENSION = "pdf";

	public PDFFileFilter()
	{
		super();
	}

	public boolean accept(java.io.File file)
	{
		if (file.isDirectory())
		{
			return true;
		}
		else if (file != null)
		{
			if (PDF_EXTENSION.equalsIgnoreCase(getExtension(file)))
			{
				return true;
			}
		}

		return false;
	}

	public String getDescription()
	{
		return "*.pdf";
	}

	public static String getExtension(File f)
	{
		String ext = null;
		String s = f.getName();
		int i = s.lastIndexOf('.');

		if (i > 0 && i < s.length() - 1)
		{
			ext = s.substring(i + 1).toLowerCase();
		}

		return ext;
	}
}
