package jPDFPreflightSamples;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class IconTreeRenderer extends DefaultTreeCellRenderer
{
	public IconTreeRenderer()
	{
		super();
	}

	public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus)
	{
		super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

		if (value instanceof IconTreeNode)
		{
			IconTreeNode node = (IconTreeNode) value;
			if (node.getIcon() instanceof ImageIcon)
			{
				ImageIcon ourIcon = (ImageIcon) node.getIcon();
				setIcon(new ImageIcon(ourIcon.getImage().getScaledInstance((int)(ourIcon.getIconWidth() * SampleUtil.getDPIScalingMultiplier()), (int)(ourIcon.getIconHeight() * SampleUtil.getDPIScalingMultiplier()), Image.SCALE_SMOOTH)));
			}
			else
			{
				setIcon(node.getIcon());
			}

			setFont(getFont().deriveFont(Font.PLAIN));
		}
		else
		{
			if (getIcon() instanceof ImageIcon)
			{
				setIcon(new ImageIcon(((ImageIcon)getIcon()).getImage().getScaledInstance((int)(getIcon().getIconWidth() * SampleUtil.getDPIScalingMultiplier()), (int)(getIcon().getIconHeight() * SampleUtil.getDPIScalingMultiplier()), Image.SCALE_SMOOTH)));
			}
			setFont(getFont().deriveFont(Font.PLAIN));
		}

		return this;
	}

	public void paint(java.awt.Graphics g)
	{
		((Graphics2D) g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
		super.paint(g);
	}

}