package jPDFPreflightSamples;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorDialog extends JDialog
{
	private JPanel jPanel;
	private JButton jbOK;
	private JLabel jlSuccesses;
	private JLabel jlErrors;
	private JScrollPane jspErrorMessages;

	public ErrorDialog(Frame parent)
	{
		super(parent);
		
		setModal(true);
		setResizable(true);
		setContentPane(getJPanel());
		setTitle("Error");
		getRootPane().setDefaultButton(getJbOK());
	}

	private JPanel getJPanel()
	{
		if (jPanel == null)
		{
			jPanel = new JPanel();
			jPanel.setLayout(new BoxLayout(jPanel, BoxLayout.Y_AXIS));

			jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
			jPanel.add(getJlSuccesses());

			jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
			jPanel.add(getJlErrors());

			jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
			jPanel.add(getJspErrorMessages());

			JPanel jpButton = new JPanel();
			jpButton.add(getJbOK());
			jPanel.add(jpButton);
		}
		return jPanel;
	}

	private JLabel getJlSuccesses()
	{
		if (jlSuccesses == null)
		{
			jlSuccesses = new JLabel();
		}
		return jlSuccesses;
	}

	private JLabel getJlErrors()
	{
		if (jlErrors == null)
		{
			jlErrors = new JLabel();
		}
		return jlErrors;
	}

	private JScrollPane getJspErrorMessages()
	{
		if (jspErrorMessages == null)
		{
			jspErrorMessages = new JScrollPane();
			jspErrorMessages.setPreferredSize(new Dimension((int)(500 * SampleUtil.getDPIScalingMultiplier()), (int)(200 * SampleUtil.getDPIScalingMultiplier())));
		}
		return jspErrorMessages;
	}

	private JButton getJbOK()
	{
		if (jbOK == null)
		{
			jbOK = new JButton("OK");
			jbOK.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e)
				{
					dispose();
				}
			});
		}
		return jbOK;
	}

	public void setErrorMessages(List messages)
	{
		Collections.sort(messages, new Comparator() {
			public int compare(Object o1, Object o2)
			{
				return Collator.getInstance().compare(o1, o2);
			}
		});

		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < messages.size(); i++)
		{
			sb.append(messages.get(i));
			sb.append("\n");
		}

		getJspErrorMessages().setViewportView(new JTextArea(sb.toString()));
	}

	public void setErrorCount(int count)
	{
		getJlErrors().setText(count + " file(s) had errors");
	}

	public void setSuccesCount(int count)
	{
		getJlSuccesses().setText(count + " file(s) processed successfully");
	}

	public void showDialog()
	{
		pack();
		setLocationRelativeTo(getParent());
		setVisible(true);
	}

}
