package jPDFPreflightSamples;

import java.io.IOException;

import com.qoppa.pdf.PDFException;
import com.qoppa.pdfPreflight.PDFPreflight;
import com.qoppa.pdfPreflight.profiles.PDFAConversionOptions;
import com.qoppa.pdfPreflight.profiles.PDFA_1_B_Conversion;
import com.qoppa.pdfPreflight.results.PreflightResults;

public class ConvertToPDFA {

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		try
		{
			System.out.println("Starting");
			PDFPreflight pdfPreflight = new PDFPreflight("C:\\input.pdf", null);
			
			// Create a new conversion profile 
			PDFA_1_B_Conversion profile = new PDFA_1_B_Conversion();
		
			// Set conversion options
			PDFAConversionOptions options = (PDFAConversionOptions) profile.getConversionOptions();
			options.setEmbeddedFiles(PDFAConversionOptions.OPTION_DELETE);
			options.setTransparency(PDFAConversionOptions.OPTION_WARN);
			options.setUnsupportedAnnotations(PDFAConversionOptions.OPTION_DELETE);
			
			
			// Convert the document
			PreflightResults results = pdfPreflight.convertDocument(new PDFA_1_B_Conversion(), null);
			
			// Get conversion results
			if (results.isSuccessful())
			{
				System.out.println("PDF was converted successfully");
				// Save the PDF/A Document
				pdfPreflight.saveDocument("C:\\output_pdfa.pdf"); 
			} 
			else 
			{ 
				System.out.println("PDF was not converted, see report"); 
				// Add annotations to the document 
				pdfPreflight.addResultAnnotations(results); 
				// Append report to the document 
				pdfPreflight.appendPreflightReport(results, 612, 792); 
				// Save the PDF document with annotations and report
				pdfPreflight.saveDocument("C:\\conversionreport.pdf"); 
			}
		}
		catch(PDFException pdfe)
		{
			System.out.println(pdfe);
		}
		catch(IOException ioe)
		{
			System.out.println(ioe);
		}
		catch(Throwable t)
		{
			System.out.println(t);
		}
	}
}