/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.SpellChecker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

class RedZigZagPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private static final BasicStroke STROKE1 = new BasicStroke(0.01f, 0, 0, 10.0f, new float[]{1.0f, 3.0f}, 0.0f);
    private static final BasicStroke STROKE2 = new BasicStroke(0.01f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 1.0f);
    private static final BasicStroke STROKE3 = new BasicStroke(0.01f, 0, 0, 10.0f, new float[]{1.0f, 3.0f}, 2.0f);

    public RedZigZagPainter() {
        super(SpellChecker.getOptions().getSpellCheckerColor());
    }

    @Override
    public Shape paintLayer(Graphics g, int i, int j, Shape shape, JTextComponent jtext, View view) {
        if (jtext.isEditable()) {
            g = g.create();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setColor(SpellChecker.getOptions().getSpellCheckerColor());
            try {
                Shape sh = view.modelToView(i, Position.Bias.Forward, j, Position.Bias.Backward, shape);
                Rectangle rect = sh instanceof Rectangle ? (Rectangle)sh : sh.getBounds();
                this.drawZigZagLine(g, rect.x, rect.y, rect.width, rect.height);
                return rect;
            }
            catch (BadLocationException badlocationexception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        Rectangle alloc = bounds.getBounds();
        try {
            TextUI mapper = c.getUI();
            Rectangle p0 = mapper.modelToView(c, offs0);
            Rectangle p1 = mapper.modelToView(c, offs1);
            g = g.create();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Color color = SpellChecker.getOptions().getSpellCheckerColor();
            if (color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(color);
            }
            if (p0.y == p1.y) {
                p1 = mapper.modelToView(c, offs1 - 1);
                Rectangle r = p0.union(p1);
                this.drawZigZagLine(g, r.x, r.y, r.width, r.height);
            } else {
                int i = offs0 + 1;
                while (i < offs1) {
                    Rectangle r;
                    p1 = mapper.modelToView(c, i);
                    if (p0.y != p1.y) {
                        p1 = mapper.modelToView(c, i - 1);
                        r = p0.union(p1);
                        this.drawZigZagLine(g, r.x, r.y, r.width, r.height);
                        p0 = mapper.modelToView(c, i);
                    } else if (i == offs1 - 1) {
                        p1 = mapper.modelToView(c, i);
                        r = p0.union(p1);
                        this.drawZigZagLine(g, r.x, r.y, r.width, r.height);
                    }
                    ++i;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void drawZigZagLine(Graphics g, int x, int y, int width, int height) {
        int x2 = x + width - 1;
        y = y + height - 1;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(STROKE1);
        g2.drawLine(x, y, x2, y);
        g2.setStroke(STROKE2);
        g2.drawLine(x, --y, x2, y);
        g2.setStroke(STROKE3);
        g2.drawLine(x, --y, x2, y);
    }
}

