/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.CheckerListener;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.SpellChecker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

class PopupListener
extends MouseAdapter
implements LanguageChangeListener {
    private JPopupMenu menu;

    public PopupListener(JPopupMenu menu) {
        this.menu = menu;
        SpellChecker.addLanguageChangeLister(this);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            if (SpellChecker.getOptions().isSubMenu()) {
                this.menu = new JPopupMenu();
                this.menu.add(SpellChecker.createCheckerMenu());
                this.menu.add(SpellChecker.createLanguagesMenu());
            } else {
                this.menu = SpellChecker.createCheckerPopup();
            }
        }
        return this.menu;
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.maybeShowPopup(ev);
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.maybeShowPopup(ev);
    }

    private void maybeShowPopup(MouseEvent ev) {
        PopupMenuListener[] popupMenuListeners;
        PopupMenuListener[] popupMenuListenerArray = popupMenuListeners = this.getPopupMenu().getPopupMenuListeners();
        int n = popupMenuListeners.length;
        int n2 = 0;
        while (n2 < n) {
            PopupMenuListener popupMenuListener = popupMenuListenerArray[n2];
            if (popupMenuListener instanceof CheckerListener && !((CheckerListener)popupMenuListener).willPopupMenuBeEnabled((JTextComponent)ev.getComponent())) {
                return;
            }
            ++n2;
        }
        if (ev.isPopupTrigger() && ev.getComponent().isShowing()) {
            this.getPopupMenu().show(ev.getComponent(), ev.getX(), ev.getY());
        }
    }

    @Override
    public void languageChanged(LanguageChangeEvent ev) {
        this.menu = null;
    }
}

