/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Dictionary;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.RedZigZagPainter;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Tokenizer;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

class AutoSpellChecker
implements DocumentListener,
LanguageChangeListener {
    private static final RedZigZagPainter painter = new RedZigZagPainter();
    private final JTextComponent jText;
    private final SpellCheckerOptions options;
    private Dictionary dictionary;
    private Locale locale;

    public AutoSpellChecker(JTextComponent text, SpellCheckerOptions options) {
        this.jText = text;
        this.options = options == null ? SpellChecker.getOptions() : options;
        this.jText.getDocument().addDocumentListener(this);
        SpellChecker.addLanguageChangeLister(this);
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
        this.checkAll();
    }

    static void disable(JTextComponent text) {
        AbstractDocument doc = (AbstractDocument)text.getDocument();
        DocumentListener[] documentListenerArray = doc.getDocumentListeners();
        int n = documentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentListener listener = documentListenerArray[n2];
            if (listener instanceof AutoSpellChecker) {
                AutoSpellChecker autoSpell = (AutoSpellChecker)listener;
                doc.removeDocumentListener(autoSpell);
                AutoSpellChecker.removeHighlights(text);
            }
            ++n2;
        }
    }

    private static void removeHighlights(JTextComponent text) {
        Highlighter highlighter = text.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        int n = highlightArray.length;
        int n2 = 0;
        while (n2 < n) {
            Highlighter.Highlight highlight = highlightArray[n2];
            if (highlight.getPainter() == painter) {
                highlighter.removeHighlight(highlight);
            }
            ++n2;
        }
    }

    static void refresh(JTextComponent text) {
        AbstractDocument doc = (AbstractDocument)text.getDocument();
        DocumentListener[] documentListenerArray = doc.getDocumentListeners();
        int n = documentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentListener listener = documentListenerArray[n2];
            if (listener instanceof AutoSpellChecker) {
                AutoSpellChecker autoSpell = (AutoSpellChecker)listener;
                autoSpell.checkAll();
            }
            ++n2;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        this.checkElements(ev.getOffset(), ev.getLength());
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
        this.checkElements(ev.getOffset(), 0);
    }

    private void checkElements(int offset, int length) {
        int end = offset + length;
        Document document = this.jText.getDocument();
        do {
            Element element;
            try {
                element = ((AbstractDocument)document).getParagraphElement(offset);
            }
            catch (Exception ex) {
                return;
            }
            this.checkElement(element);
            int endOffset = element.getEndOffset();
            int n = offset = endOffset > offset ? endOffset : offset + 1;
        } while (offset <= end && offset < document.getLength());
    }

    private void checkElement(Element element) {
        try {
            String word;
            int i = element.getStartOffset();
            int j = element.getEndOffset();
            Highlighter highlighter = this.jText.getHighlighter();
            Highlighter.Highlight[] highlights = highlighter.getHighlights();
            int k = highlights.length;
            while (--k >= 0) {
                Highlighter.Highlight highlight = highlights[k];
                int hlStartOffset = highlight.getStartOffset();
                int hlEndOffset = highlight.getEndOffset();
                if ((i > hlStartOffset || hlStartOffset > j) && (i > hlEndOffset || hlEndOffset > j) || highlight.getPainter() != painter) continue;
                highlighter.removeHighlight(highlight);
            }
            int l = ((AbstractDocument)this.jText.getDocument()).getLength();
            if (i >= (j = Math.min(j, l))) {
                return;
            }
            Dictionary dic = this.dictionary;
            Locale loc = this.locale;
            if (dic == null || loc == null) {
                return;
            }
            Tokenizer tok = new Tokenizer(this.jText, dic, loc, i, j, this.options);
            while ((word = tok.nextInvalidWord()) != null) {
                int wordOffset = tok.getWordOffset();
                highlighter.addHighlight(wordOffset, wordOffset + word.length(), painter);
            }
        }
        catch (BadLocationException e) {
            SpellChecker.getMessageHandler().handleException(e);
        }
    }

    private void checkAll() {
        if (this.jText == null) {
            return;
        }
        if (this.dictionary == null) {
            AutoSpellChecker.removeHighlights(this.jText);
            return;
        }
        if (this.jText.getDocument().getLength() == 0) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Document document = AutoSpellChecker.this.jText.getDocument();
                int i = 0;
                while (i < document.getLength()) {
                    try {
                        final Element element = ((AbstractDocument)document).getParagraphElement(i);
                        i = element.getEndOffset();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AutoSpellChecker.this.checkElement(element);
                            }
                        });
                    }
                    catch (Exception ex) {
                        return;
                    }
                }
            }
        }, "JOrtho checkall");
        thread.setPriority(4);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void languageChanged(LanguageChangeEvent ev) {
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
        this.checkAll();
    }
}

